#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <deque>
#include <map>
#include <unordered_map>
#include <set>
#include <unordered_set>
#include <bitset>
#include <iomanip>
#include <cassert>
#include <random>
#include <ctime>

#define int long long
#define ld long double
#define p_b push_back
#define pii pair<int,int>
#define fi first
#define se second
#define m_p make_pair
#define all(x) x.begin(),x.end()
#define rall(x) x.rbegin(),x.rend()
#define sz(x) (int)x.size()
#define sqr(x) ((x)*(x))
#define pw(x) (1LL<<(x))

using namespace std;

class DSU
{
private:
    int n;
    int cmp;
    vector < int > p, sz;

private:
    int find_set(int v)
    {
        return v == p[v] ? v : p[v] = find_set(p[v]);
    }

public:
    DSU(int n) : n(n)
    {
        p.resize(n);
        for(int i = 0; i < n; i++)
            p[i] = i;
        sz.resize(n, 1);
        cmp = n;
    }

    bool check(int v, int u)
    {
        return find_set(v) == find_set(u);
    }

    bool unite(int v, int u)
    {
        v = find_set(v);
        u = find_set(u);
        if(v == u)
            return false;
        if(sz[v] < sz[u])
            swap(v, u);
        p[u] = v;
        sz[v] += sz[u];
        cmp--;
        return true;
    }

    int comp()
    {
        return cmp;
    }
};

const ld e = 1e-9;

struct line
{
    int x, y, _x, _y;
};

ld K(line a)
{
    return (ld)(a._y - a.y) / (ld)(a._x - a.x);
}

ld B(line a)
{
    return (ld)a.y - K(a) * a.x;
}

ld Y(line l, ld x)
{
    return K(l) * x + B(l);
}

bool eq(ld x, ld y)
{
    return abs(x - y) < e;
}

int cross(line f, line s)
{
    pii c1 = {f.x, f.y};
    pii c2 = {f._x, f._y};
    pii c3 = {s.x, s.y};
    pii c4 = {s._x, s._y};
    if(c1 == c3 || c1 == c4 || c2 == c3 || c2 == c4)
        return 0;

    if(f.x != f._x && s.x != s._x)
    {
        if(f.x > f._x)
        {
            swap(f.x, f._x);
            swap(f.y, f._y);
        }

        if(s.x > s._x)
        {
            swap(s.x, s._x);
            swap(s.y, s._y);
        }

        ld k1 = K(f), b1 = B(f);
        ld k2 = K(s), b2 = B(s);
        if(eq(k1, k2))
            return -1;

        if(eq(Y(s, f.x), f.y) && s.x <= f.x && f.x <= s._x || eq(Y(s, f._x), f._y) && s.x <= f._x && f._x <= s._x || eq(Y(f, s.x), s.y) && f.x <= s.x && s.x <= f._x || eq(Y(f, s._x), s._y) && f.x <= s._x && s._x <= f._x)
            return 1;

        ld x = (b2 - b1) / (k1 - k2);
        if(max(f.x, s.x) - x > e || x - min(f._x, s._x) > e)
            return -1;
        return 2;
    }

    if(f.y > f._y)
    {
        swap(f.x, f._x);
        swap(f.y, f._y);
    }

    if(s.y > s._y)
    {
        swap(s.x, s._x);
        swap(s.y, s._y);
    }

    if(f.x == f._x && s.x == s._x)
        return -1;

    if(f.x != f._x)
        swap(f, s);

    if(s.x == f.x && f.y <= s.y && s.y <= f._y || s._x == f.x && f.y <= s._y && s._y <= f._y)
        return 1;

    ld x = f.x;
    ld y = Y(s, x);
    if(f.y - y > e || y - f._y > e || min(s.x, s._x) - x > e || x - max(s.x, s._x) > e)
        return -1;
    return 2;
}

void solve()
{
    int n;
    cin >> n;
    vector < line > l(n);
    for(auto &[x, y, _x, _y] : l)
        cin >> x >> y >> _x >> _y;

//    for(auto a : l)
//        cout << K(a) << " " << B(a) << '\n';

    DSU dsu = DSU(n);
    int V = n * 2;
    int E = n;
    for(int i = 0; i < n; i++)
        for(int j = i + 1; j < n; j++)
        {
            int sost = cross(l[i], l[j]);
//            cout << i << " " << j << " " << sost << '\n';
            if(sost == -1)
                continue;
            dsu.unite(i, j);
            if(!sost)
                V--;
            if(sost == 2)
                V++;
            E += sost;
        }
    int k = dsu.comp();
//    cout << V << " " << E << " " << k << '\n';
    int G = E - V + k + 1;
    cout << G << '\n';
}

main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int T;
    cin >> T;
    while(T--)
        solve();
    return 0;
}

/*

1
5
1 4 1 1
3 3 0 1
1 2 0 3
3 3 1 3
2 3 3 2

1
5
4 1 1 2
0 2 1 1
1 2 1 1
0 2 4 1
3 1 0 3

*/
